/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.world;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.StructureSpawnListGatherEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;

public class StructureSpawnManager {
    private static Map<Structure<?>, StructureSpawnInfo> structuresWithSpawns = Collections.emptyMap();

    public static void gatherEntitySpawns() {
        LinkedHashMap structuresWithSpawns = new LinkedHashMap();
        StructureSpawnManager.gatherEntitySpawns(structuresWithSpawns, Structure.field_236374_j_);
        StructureSpawnManager.gatherEntitySpawns(structuresWithSpawns, Structure.field_236366_b_);
        StructureSpawnManager.gatherEntitySpawns(structuresWithSpawns, Structure.field_236376_l_);
        StructureSpawnManager.gatherEntitySpawns(structuresWithSpawns, Structure.field_236378_n_);
        for (Structure<?> structure : ForgeRegistries.STRUCTURE_FEATURES.getValues()) {
            if (structure == Structure.field_236374_j_ || structure == Structure.field_236366_b_ || structure == Structure.field_236376_l_ || structure == Structure.field_236378_n_) continue;
            StructureSpawnManager.gatherEntitySpawns(structuresWithSpawns, structure);
        }
        StructureSpawnManager.structuresWithSpawns = structuresWithSpawns;
    }

    private static void gatherEntitySpawns(Map<Structure<?>, StructureSpawnInfo> structuresWithSpawns, Structure<?> structure) {
        StructureSpawnListGatherEvent event = new StructureSpawnListGatherEvent(structure);
        MinecraftForge.EVENT_BUS.post((Event)event);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        event.getEntitySpawns().forEach((classification, spawns) -> {
            if (!spawns.isEmpty()) {
                builder.put(classification, (Object)ImmutableList.copyOf((Collection)spawns));
            }
        });
        ImmutableMap entitySpawns = builder.build();
        if (!entitySpawns.isEmpty()) {
            structuresWithSpawns.put(structure, new StructureSpawnInfo((Map)entitySpawns, event.isInsideOnly()));
        }
    }

    @Nullable
    public static List<MobSpawnInfo.Spawners> getStructureSpawns(StructureManager structureManager, EntityClassification classification, BlockPos pos) {
        for (Map.Entry<Structure<?>, StructureSpawnInfo> entry : structuresWithSpawns.entrySet()) {
            Structure<?> structure = entry.getKey();
            StructureSpawnInfo spawnInfo = entry.getValue();
            if (!spawnInfo.spawns.containsKey(classification) || !structureManager.func_235010_a_(pos, spawnInfo.insideOnly, structure).func_75069_d()) continue;
            return (List)spawnInfo.spawns.get(classification);
        }
        return null;
    }

    public static List<MobSpawnInfo.Spawners> getSpawnList(Structure<?> structure, EntityClassification classification) {
        if (structuresWithSpawns.containsKey(structure)) {
            return structuresWithSpawns.get(structure).spawns.getOrDefault(classification, Collections.emptyList());
        }
        return Collections.emptyList();
    }

    private static class StructureSpawnInfo {
        private final Map<EntityClassification, List<MobSpawnInfo.Spawners>> spawns;
        private final boolean insideOnly;

        private StructureSpawnInfo(Map<EntityClassification, List<MobSpawnInfo.Spawners>> spawns, boolean insideOnly) {
            this.spawns = spawns;
            this.insideOnly = insideOnly;
        }
    }
}

